function [tthco,untscount] = importfileXRD2(filename, binby)
%[twoTheta,counts] = importfileXRD2(filename, binby)
% Reads a data file and bins the counts of the 2nd column by the binby arg.
% A. London 2014
% binby=16;
% filename = 'C:\Users\andy\Downloads\a\dls\i11\data\2012\ee7528-1\211286-mac-001.dat';

fileFormat = '%f %f %f'; % file format

fid = fopen(filename);
if fid < 0
    error(['Can''t open:' filename]);
end
Nrows = numel(cell2mat(textscan(fid,'%1c%*[^\n]')))+1; % get num. rows total
frewind(fid);
i=1;

while ~feof(fid)
    s = fgets(fid);
    t = sscanf(s,fileFormat); 
    if length(t) == length(strfind(fileFormat,'%'))
        headerEndBytes = ftell(fid)-length(s); % set header position
        headerEndRows = i; % set header position
        break
    end
    i = i+1;
end
fseek(fid,headerEndBytes,'bof');

a = zeros(Nrows-headerEndRows,3);
i=1;
while ~feof(fid)
    s = fgets(fid);
    t = sscanf(s,fileFormat); % file format
    if length(t) == length(strfind(fileFormat,'%'))
        a(i,:) = t';
        i= i + 1;
    end
end

% binning
q=1;p=binby;

M=a(:,[1 2]); % only two columns
[m,n]=size(M); %M is the original matrix

% crop data so that it will bin nicely
% drop data from the end of the file
remainder = mod(m,binby);
M = M(1:(end-remainder),:);
[m,n]=size(M); %M is the original matrix

% reshaping and summing
M=sum( reshape(M,p,[]) ,1 );
M=reshape(M,m/p,[]).'; %Note transpose

M=sum( reshape(M,q,[]) ,1);
M=reshape(M,n/q,[]).'; %Note transpose

tthco = M(:,1)/binby;
untscount = M(:,2);
end