function [reflexions,header,formla,labels,textName] = importReflectionsList(filename,thresholdIntensity,overlapWidth)
%IMPORTFILE Import numeric data from a text file as a matrix.
%   FEOREFLEXIONS = IMPORTFILE(FILENAME) Reads data from text file FILENAME
%   for the default selection.
%
%   FEOREFLEXIONS = IMPORTFILE(FILENAME, STARTROW, ENDROW) Reads data from
%   rows STARTROW through ENDROW of text file FILENAME.
%
% Example:
%   FeOReflexions = importfile('40089-FeO Reflexions.txt', 7, 726);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2015/06/09 16:20:03

%% Initialize variables.
if nargin<2
    thresholdIntensity=20;
end
if nargin<3
    overlapWidth=0.1;
end
    startRow = 7;
    endRow = inf;

%% Read columns of data as strings:
% For more information, see the TEXTSCAN documentation.
formatSpec = '%3s%4s%4s%10s%10s%14s%8s%4s%6s%s%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
textscan(fileID, '%[^\n\r]', startRow(1)-1, 'ReturnOnError', false);
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', '', 'WhiteSpace', '', 'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    textscan(fileID, '%[^\n\r]', startRow(block)-1, 'ReturnOnError', false);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', '', 'WhiteSpace', '', 'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Convert the contents of columns containing numeric strings to numbers.
% Replace non-numeric strings with NaN.
raw = repmat({''},length(dataArray{1}),length(dataArray));
for col=1:length(dataArray)-1
    raw(1:length(dataArray{col}),col) = dataArray{col};
end
numericData = NaN(size(dataArray{1},1),size(dataArray,2));

for col=[1,2,3,4,5,6,7,8,9,10]
    % Converts strings in the input cell array to numbers. Replaced non-numeric
    % strings with NaN.
    rawData = dataArray{col};
    for row=1:size(rawData, 1);
        % Create a regular expression to detect and remove non-numeric prefixes and
        % suffixes.
        regexstr = '(?<prefix>.*?)(?<numbers>([-]*(\d+[\,]*)+[\.]{0,1}\d*[eEdD]{0,1}[-+]*\d*[i]{0,1})|([-]*(\d+[\,]*)*[\.]{1,1}\d+[eEdD]{0,1}[-+]*\d*[i]{0,1}))(?<suffix>.*)';
        try
            result = regexp(rawData{row}, regexstr, 'names');
            numbers = result.numbers;
            
            % Detected commas in non-thousand locations.
            invalidThousandsSeparator = false;
            if any(numbers==',');
                thousandsRegExp = '^\d+?(\,\d{3})*\.{0,1}\d*$';
                if isempty(regexp(thousandsRegExp, ',', 'once'));
                    numbers = NaN;
                    invalidThousandsSeparator = true;
                end
            end
            % Convert numeric strings to numbers.
            if ~invalidThousandsSeparator;
                numbers = textscan(strrep(numbers, ',', ''), '%f');
                numericData(row, col) = numbers{1};
                raw{row, col} = numbers{1};
            end
        catch me
        end
    end
end


%% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells

%% Create output variable
reflexions = raw(cell2mat(raw(:,7))>thresholdIntensity,1:end-1);
header = {'h','k','l','d(hkl)','2-Theta','Intensity','I/Imax','m','N','Lp'};

%% Get formula from file name
% remove suffix
filename = regexprep(filename,'Reflexions\.txt','');
% remove ID number
[~,i]=regexp(filename,'\d*');
% formula string
f = filename((i+2):end);
textName = f;
% separate into parts
fparts = regexp(f,'[A-Z][a-z]|[A-z]|[1-9]*','match');
nparts = ~isnan(str2double(fparts));
fparts(nparts) = cellfun(@(x) strcat('[',x,']*'),fparts(nparts),'uni',0);
formla = horzcat(fparts{:});
if strcmp(formla(end),'*')
    formla = formla(1:end-1);
end
hkl = cellfun(@(x,y,z) strcat('(',plotmathBar(x),'*',plotmathBar(y),'*',plotmathBar(z),')'),reflexions(:,1),reflexions(:,2),reflexions(:,3),'uni',0);
% detect overlaps
d = diff(cell2mat(reflexions(:,5)))<=overlapWidth;
p = logical([0; d]);
overlaps = find([diff([0; d])==1; 0]);
for i = 1:length(overlaps)
    if i == length(overlaps)
        ival = overlaps(i):(size(hkl,1)-1);
    else
        ival = overlaps(i):(overlaps(i+1)-1);
    end
    ival = unique([ival(d(ival)) ival(p(ival))]); % find overlaped reflexions
    ival = logical(full(sparse(ival,ones(size(ival)),1,size(hkl,1),1)));
    additional = hkl(p&ival);
    hkl(overlaps(i)) = strcat(hkl(overlaps(i)),additional{:});
    reflexions{overlaps(i),4} = mean(vertcat(reflexions{ival,5})); % d-hkl average
    reflexions{overlaps(i),5} = mean(vertcat(reflexions{ival,5})); % 2-theta average
    reflexions{overlaps(i),6} = sum(vertcat(reflexions{ival,6})); % int %
    reflexions{overlaps(i),7} = sum(vertcat(reflexions{ival,7})); % intensity
end
% crop out overlaps
reflexions = reflexions(~[0; d],:);
hkl = hkl(~[0; d]);
labels = strcat(hkl,'-',formla);
end
