function [dist,percent,err,ions,ionCount,atomCount] = importIVASprofile(filename)
% grain boundary segregation from 1D line profiles exported from ivas
% Doesn't deal well with named/unknown ions! Due to ionic->atomic
% conversion
% Assumes the line profiel is along the Z direction
% target elements

% file
f = filename;
% read headers
fid=fopen(f);
t=fgets(fid);
headers = regexp(t,',','split');
fclose(fid);
ions = regexprep(headers(4:3+(length(headers)-3)/2),' %','');
% read data
n = csvread(f,1,0);
dist = n(:,1);
z = max(dist)-min(dist);
ionCount = n(:,2);
atomCount = n(:,3);
percent = n(:,4:3+(length(headers)-3)/2); % first half of the data (ignoring dist and counts)
err = n(:,4+(length(headers)-3)/2:end); % second half

if(0)
    % possibly needs composing into atomic counts?
    % Doesn't deal well with named/unknown ions!
    [tab,ele]=ions2ionTable(ionStr2ions(ions));
    % is this atomic or ionic?
    nonEle = percent(:,~ismember(ions,ele));
    if sum(nonEle(:)) == 0
        % is atomic (only elemental ions)
        disp('Atomic');
        counts = percent.*repmat(atomCount,1,size(percent,2))./100;
        countSigma = err.*repmat(atomCount,1,size(percent,2))./100;
        counts = counts*tab;
    else
        % contains molecular ions
        disp('Ionic');
        countsI = percent.*repmat(ionCount,1,size(percent,2))./100;
        countISigma = err.*repmat(ionCount,1,size(percent,2))./100;
        counts = countsI*tab;
        countSigma = countISigma*tab;
    end
end
end