function [dmaxnm,Count,RandomizedCount,nmin] = importCCDfile(filename, startRow, endRow)
%IMPORTFILE Import numeric data from a text file as column vectors.
% Import a cluster count distribution made by IVAS
%   [DMAXNM,COUNT,RANDOMIZEDCOUNT] = IMPORTFILE(FILENAME) Reads data from
%   text file FILENAME for the default selection.
%
%   [DMAXNM,COUNT,RANDOMIZEDCOUNT] = IMPORTFILE(FILENAME, STARTROW, ENDROW)
%   Reads data from rows STARTROW through ENDROW of text file FILENAME.
%
% Example:
%   [dmaxnm,Count,RandomizedCount] =
%   importfile('R14_18420-v01_CCD_8.csv',9, 42);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2014/07/29 13:18:06

%% Initialize variables.
delimiter = ',';
if nargin<=2
    startRow = 9;
    endRow = inf;
end

%% Format string for each line of text:
%   column1: double (%f)
%	column2: double (%f)
%   column3: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%f%f%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
textscan(fileID, '%[^\n\r]', startRow(1)-1, 'ReturnOnError', false);
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    textscan(fileID, '%[^\n\r]', startRow(block)-1, 'ReturnOnError', false);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Allocate imported array to column variable names
dmaxnm = dataArray{:, 1};
Count = dataArray{:, 2};
RandomizedCount = dataArray{:, 3};

% get nmin
nmin = importCCDfile_count(filename);
