% script for histogram data plotting
% this uses an xls spreadsheet with the output of
% DataReader.m as separate sheets
% Original work by A. London, Jan 2013
% requires the ternary2 package for terplot
% (terplot modified by A. London 2012)

% example data read 'conversion' to an xls file:
%clusterDataReader('R14_16731-v01_YTiOYO.csv');
% the above outputs 'R14_*_decomp.xls'
% this can be copied into allClusterAnalysis using batchwrite.m

% or run it for a single decomp.xls file:
clusterPlot=cell(1);
if(1)
    minSolute = 0.001; %
    minYFraction = 0.05;
    %xlsFiles = {'R14_16416-v02_YO2YO_80_decomp.xls';'R14_15734-v02_YYOTiOO_80_09_decomp.xls'};
    for fileN = 1:length(xlsFiles)
        xlsData=xlsread(xlsFiles{fileN});
        solutePercent = sum(xlsData(:,3:5),2)./sum(xlsData(:,1:5),2);
        soluteFiltered = xlsData(solutePercent>minSolute,:);
        YFrac = soluteFiltered(:,3)./sum(soluteFiltered(:,3:5),2);
        clusterPlot{fileN} = soluteFiltered(YFrac>minYFraction,(end-2):end); % only read last 3 columns
        % generate legend text
        S = textscan(xlsFiles{fileN},'R14_%s','delimiter','-');
        legendText{fileN} = S{1}{1};
    end
    gh = zeros(1,length(xlsFiles)); % array for graphics handles
end
% get all data:
data = clusterPlot{1}(:,3);
for p = 2:length(xlsFiles)
    data = [data; clusterPlot{p}(:,3)];
end
% plot histograms
hist(data,25);