function [fitresult, r] = gfit(x, y1)
%[fitresult, r] = gfit(x, y1)
% fit a gaussian and return the R of the fit
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input : x
%      Y Output: y1
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 10-Dec-2013 16:48:23


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( x, y1 );

% Set up fittype and options.
ft = fittype( 'gauss1' );
opts = fitoptions( ft );
opts.Display = 'Off';
opts.Lower = [-Inf -Inf 0];
opts.StartPoint = [1.20205844074773 51 10.8668794291733];
opts.Upper = [Inf Inf Inf];
ME = MException('gfit:fitting', 'fitting failed, R=0');
try
    % Fit model to data.
    [fitresult, gof] = fit( xData, yData, ft, opts );
    r = gof.rsquare;
catch ME
    r = 0;
    fitresult = 0;
end
end


