% get cluster csv files exported from IVAS (from a particular folder) as
% well as the number of clusters found in the cluster.indexed.rrng files in
% the (hopefully) approiate correct IVAS project (in fileRoot).
%% get run numbers from cluster files
% from which folder?
clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
fileRoot = 'C:\Users\Andy\APT\';
files = dir(strcat(clusterRoot,'R14_*.csv'));
C={files.name}';
num_files = length(C);
runs = regexp(C,'\d{5}','match');
runs = cellfun(@str2double,runs);
[runs,ia] = unique(runs,'stable');
v = regexp(C,'(?<=-v)\d{2}','match');
v = v(ia);
% hack for missing data
v(38) = {{'02'}};

ns = zeros(length(runs),1); % indexed cluster rrng files
nc = zeros(length(runs),1); % clsuter files
cf = cell(length(runs),1); % cluster files
rf = cell(length(runs),1); % rrng files

for i=1:length(runs)
    disp('*');
    %% cluster files
    % list relevent cluster files to choose
    cfiles = dir(strcat(clusterRoot,'R14_',num2str(runs(i)),'*.csv'));
    cfiles = {cfiles.name}';
    if length(cfiles)>1
        for k=1:length(cfiles)
            % get number of clusters from cluster.csv file:
            [~,~,~,~,~,n,~] = clusterSettingsNumeric(strcat(clusterRoot,cfiles{k}));
            disp(strcat('[',num2str(k),']=',num2str(n),'-clusters:',cfiles{k}));
        end
    elseif length(cfiles)<1
        % I don't think this should ever occur (as we are using a list
        % based on the csv files...)
        error(strcat('Not found cluster file:',strcat(clusterRoot,'R14_',num2str(runs(i)),'*.csv')));
    else
        % length == 1
        % get number of clusters from cluster.csv file:
        [~,~,~,~,~,n,~] = clusterSettingsNumeric(strcat(clusterRoot,cfiles{1}));
        disp(strcat('[',num2str(1),']=',num2str(n),'-clusters:',cfiles{1}));
        nc(i) = 1; % this the choice for which cluster file to use
        cf{i} = cfiles{1};
    end
    %% find recon folder
    a = dir(strcat(fileRoot,'R14_',num2str(runs(i)),'*'));
    hits = {a.name}';
    folder = hits(cell2mat({a.isdir}));
    % find indexed cluster rrng file
    a = dir(strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\R14_*.cluster.indexed.rrng'));
    names = {a.name}';
    if length(names)>1
        disp('found:')
        for j=1:length(names)
            % get number of clusters from rrng file:
            [n]=clusterRrngN( strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\',names{j}) );
            disp(strcat('[',num2str(j),']=',num2str(n),'-clusters:',names{j}));
        end
        userChoice = input('Enter number for rrng file:');
        name = names{userChoice};
        
    elseif length(names)==1
        name = names{1};
        [n]=clusterRrngN(strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\',name));
        disp(strcat('[',num2str(1),']=',num2str(n),'-clusters:',names{1}));
    else
        disp('not found any rrng files');
        disp(strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\'));
    end
    [n]=clusterRrngN(strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\',name));
    disp(strcat('Clusters in rrng file:',num2str(n)));
    if length(cfiles)>1
        userChoice2 = input('Enter number for csv file:');
        nc(i) = userChoice2;
        cf{i} = cfiles{userChoice2};
    end
    
    if n == 0
        disp('**failed to open rrng file**');
        disp(strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\',name));
        t=strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\');
        system(['explorer.exe ' t]);
        pause
    else
        rf{i} = strcat(fileRoot,folder{1},'\recons\recon-v',v{i}{1},'\default\',name);
        ns(i) = n; % number of clusters in indexed cluster rrng file
    end
end