% simple script to the read the extentZ of many files
% read cluster files from database
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles({'Unirrd'});
numFiles = length(matList);
extents = cell(1,numFiles);
rg = cell(1,numFiles);
rz = cell(1,numFiles);
nTable = cell(1,numFiles);
count = zeros(1,numFiles);
for f = 1:length(matList)
% read each file and store the extent:
[~,~,~,~,~,rg{f},rz{f},extents{f},nTable{f},~,~,~,~,~,count(f)] = clusterExtent(clusterFileList{f});
end

N = sum(count); % total number of clusters
rg = vertcat(rg{:}); % radius of gyration
ez = vertcat(extents{:}); %Z component of extent
rz = vertcat(rz{:}); %Rgz
n = vertcat(nTable{:}); % solute ions
rxy = sqrt(rg.^2 - rz.^2); % radius of gyration xy
a = rxy./rz; % aspect ratio
r = n.^(1/3); % volume equivalent radius
plot(r,ez,'bx',r,rz*sqrt(5),'rx') % plot results rz v ez