% trail for finding optimum smoothing span
n = 1000;
nbins = 50;
a=randn(n,1);
[y,x]=hist(a,nbins);
bw = x(3)-x(2); % bin width
countsPerBin = (normcdf(x'+bw/2)-normcdf(x'-bw/2))*n;
seq = 1:(floor(nbins/2)-1);
r2 = zeros(length(seq),1);
sse = zeros(length(seq),1);
for i=seq
    x1 = x(seq(i):(nbins-seq(i)));
    y1 = y(seq(i):(nbins-seq(i)));
    [ffit,gof] = fit(x1',y1','poly2');
    r2(seq(i)) = gof.adjrsquare;
    sse(seq(i)) = gof.sse;
end
plot(seq,r2);
% not sure how useful this is
