defRoot = 'C:\Users\andy\APT\';
[pName,pPath]=uigetfile('.pos','Choose pos file',defRoot);% get pos file;
[rName,rPath]=uigetfile('.rrng','Choose rrng file',pPath);% get rrng file;
posFile = [pPath pName];
rangeFile = [rPath rName];
level = 0.5;
result = rangeCorrector(rangeFile,posFile,level);
%result: cols 5 & 7 are the FWHM positions, 6 = range centre
[element_num, range_num, elements, ranges] = rangeReader (rangeFile);[element_num, range_num, elements, ranges] = rangeReader (rangeFile);
% make mass-spectrum
[masses] = loadMasses(posFile);
num_bins = 100000; % mass resolution = massSpecMax/num_bins
massSpecMax = 200; % maximum mass spectrum value for small pos files
% hack for clsuter pos files that have little data
masses(end) = massSpecMax;
masses(end-1) = 0;
% histogram
[y, x] = hist(masses,num_bins);
peakHeights = zeros(size(result,1),3);
for i = 1:size(result,1)
   % get  heights at FWHM positions and at the range centre
   if ~isempty(result{i,5})
       peakHeights(i,:) = [y(bx(result{i,5},x)) y(bx(result{i,6},x)) y(bx(result{i,7},x))];
   end
end
makeIon(cell2mat(result(:,15:end)),elements);
%mres = peakHeights(peakHeights(:,1)>0,2)./mean(peakHeights(peakHeights(:,1)>0,[1 3]),2)
FWHM = cell2mat(result(:,7))-cell2mat(result(:,5));
mdm = cell2mat(result(:,6))./FWHM; % M/dM
mean(mdm)