% load masses
posFile = 'fe.pos';
rangeFile = '.rrng';
[~,~,~,masses]=readpos(posFile);
num_bins = 100000; % mass resolution = massSpecMax/num_bins
massSpecMax = 200; % maximum mass spectrum value for small pos files
trailPeakHeight = 130; % Scale factor for trial peak height
% hack for clsuter pos files that have little data
masses(end) = massSpecMax;
masses(end-1) = 0;
% histogram
[heights, centres] = hist(masses,num_bins);
binwidth = centres(2)-centres(1); % bin width
[element_num, range_num, elements, ranges] = rangeReader (rangeFile);
r=1; % range number to use
% range width in number of bins
rangeWidth = round(1+(ranges{r,2})/binwidth)-(round((ranges{r,1})/binwidth));
if ( round(1+ranges{r,2}/binwidth)-round(ranges{r,1}/binwidth) ) > 3
    [pks, locs] = findpeaks(heights((round(ranges{r,1}/binwidth)):round(1+ranges{r,2}/binwidth)),'minpeakdistance',rangeWidth-1,'minpeakheight',heights(round(ranges{r,1}/binwidth))-1);
else
    % too few bins to find a peak, so expand the original range width
    error('Too few bins for good fitting!');
    [pks, locs] = findpeaks(heights((round(ranges{r,1}/binwidth)-1):round(2+ranges{r,2}/binwidth)),'minpeakdistance',rangeWidth-1,'minpeakheight',heights(round(ranges{r,1}/binwidth))-1);
end
if length(locs)~=1
    % use a dumb maximum instead, this behaviour is expected when the
    % range doesn't have a peak in it though!
    [pks,locs]=max(heights((round(ranges{r,1}/binwidth)):round(1+ranges{r,2}/binwidth)));
    %error(strcat('no peak found:',num2str(r),'; try reranging original file'));
end
gausWidth = (ranges{r,1}*3.1E-4 + 3.6E-4)*peakBroadening;
pwg = pw*gausWidth; % Peak-width guess based on gaussian width
pwb = round(pwg/binwidth); % peak width in bins
pwb2 = round(pwg*.4/binwidth); % use less-than half width for the start in bins
xbin = locs+round(ranges{r,1}/binwidth)-1; % bin number of range centre
correctedHeights = heights(xbin-pwb2:xbin+pwb) - expNoiseFit(centres(xbin-pwb2:xbin+pwb).^2)';
% fitting
noiseEst = 0; %min(heights(xbin-(0:pwb2))); % or heights(xbin-pwb2)
beta0 = [centres(xbin) gausWidth .02 (pks(1)-noiseEst)*trailPeakHeight];
ME = MException('rngcorrector:nlinfit', strcat('failed at range:',num2str(ranges{r,1})));
try
    % plot initial guess
    %plot(fitx,asyGauss(beta0(1:5),fitx),'r-.');
    % fitting
    %beta1 = nlinfit(centres(xbin-pwb2:xbin+pwb), correctedHeights, @asyGauss, beta0,statset('DerivStep',[0.00005 eps^(1/3) eps^(1/3) 1 0.5],'Display','off'));
    beta1 = nlinfit(centres(xbin-pwb2:xbin+pwb), correctedHeights, @asyGaussNoNoise, beta0,statset('DerivStep',[0.00005 eps^(1/3) eps^(1/3) 1],'Display','off'));
catch ME
    disp(strcat('failed at range:',num2str(ranges{r,1})));
    % plot initial guess
    plot(fitx,asyGaussNoNoise(beta0(1:4),fitx)+expNoiseFit(fitx.^2)','r-.');
    disp('See plot for the inital fit (red dashed line)');
    ME
end
% single asymGaus fitting:
plot(fitx,asyGaussNoNoise(beta1(1:4),fitx)+expNoiseFit(fitx.^2)','r-');