function [markers]=fwhm2(x,y,level)
%[markers]=fwhm2(x,y,level)
% Find the FWf(level)M from a smooth curve, assuming positive peak
% normalise data
%y = (y-min(y))./(max(y)-min(y));
level = 1-level;
if(level<=0 || level>=1)
    warning(['Level set to: 0.5']);
    level = 0.5; % set level as half
end
y = y./max(y); % assuming min y = 0
% remove duplicates
[y,ia]=unique(y,'stable');
[~,ci] = max(y); % index of max y
x=x(ia);
markers(1) = interp1(y(1:ci),x(1:ci),level,'linear','extrap');
markers(2) = interp1(y(ci:end),x(ci:end),level,'linear','extrap');
end