function result = fwhm(x,y,level)
% function width = fwhm(x,y,level)
%
% Full-Width at Half-Maximum (FWHM) of the waveform y(x)
% and its polarity.
% The FWHM result in 'width' will be in units of 'x'
% level = 0.5 gives width at 50% max
% level = 0.1 gives width at 90% max
% Original code [April 2006 (Patrick Egan)]
% Edited by A. London Oct 2012
level = 1-level;
y = y-min(y); % set min to zero
y = y / max(y); % normalise data
N = length(y);
if(level<=0 || level>=1)
    level = 0.5; % set level as half
end
if y(1) < level                  % find index of center max of pulse
    [~,centerindex]=max(y);
    %Pol = +1;
    %disp('Pulse Polarity = Positive')
else
    [~,centerindex]=min(y);
    %Pol = -1;
    %disp('Pulse Polarity = Negative')
end
i = 2;
while sign(y(i)-level) == sign(y(i-1)-level)
    i = i+1;
end                                   %first crossing is between v(i-1) & v(i)
interp = (level-y(i-1)) / (y(i)-y(i-1));
tlead = x(i-1) + interp*(x(i)-x(i-1));
i = centerindex+1;                    %start search for next crossing at center

while ((i < N-1) && (sign(y(i)-level) == sign(y(i-1)-level)))
    i = i+1;
end

if i >= numel(y)
    i = numel(y);
end

if i ~= N
    %disp(strcat('i =',num2str(i)));
    Ptype = 1;  
    %disp('Pulse is Impulse or Rectangular with 2 edges')
    interp = (level-y(i-1)) / (y(i)-y(i-1));
    ttrail = x(i-1) + interp*(x(i)-x(i-1));
    result(1) = tlead;
    result(2) = ttrail;
    result(3) = ttrail - tlead;
    
else
    Ptype = 2; 
    %disp('Step-Like Pulse, no second edge')
    result(1) = tlead;
    result(2) = NaN;
    result(3) = NaN;
end