%fittingTest script
% using imported data temA
% bins = 5:5:100;
% r = zeros(1,length(bins));
% for i=1:length(bins)
%     % try fitting with i bins
%     [a,b]=hist(log(temA(:,1)),bins(i));
%     ft = fittype( 'gauss1' );
%     [fitresult, gof] = fit( b', a', ft);
%     r(i) = gof.rsquare;
% end
x=0:0.5:20;
pYTi=lognfit(temA(~isnan(temA(:,1)),1));
pCr=lognfit(temA(~isnan(temA(:,2)),2));
pYex=lognfit(temA(~isnan(temA(:,3)),3));
cr=hist(temA(:,2),x);yti=hist(temA(:,1),x);yex=hist(temA(:,3),x);
subplot(3,1,1);plot(x,2*cr./sum(cr),x,lognpdf(x,pCr(1),pCr(2)));
[M,V]=lognstat(pCr(1),pCr(2));
title(strcat('Cr \mu=',num2str(M),' \sigma=',num2str(V)));
subplot(3,1,2);plot(x,2*yti./sum(yti),x,lognpdf(x,pYTi(1),pYTi(2)));
[M,V]=lognstat(pYTi(1),pYTi(2));
title(strcat('YTi \mu=',num2str(M),' \sigma=',num2str(V)));
subplot(3,1,3);plot(x,2*yex./sum(yex),x,lognpdf(x,pYex(1),pYex(2)));
[M,V]=lognstat(pYex(1),pYex(2));
title(strcat('Yex \mu=',num2str(M),' \sigma=',num2str(V)));