% quick script to check if a set of files exists
%get data
opts = {'Irrd'};
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts);
opts = {'UnirrdFull'};
[rangeFileList2,posFileList2,clusterFileList2,volList2,matList2]=clusterFiles(opts);
rangeFileList = [rangeFileList rangeFileList2];
posFileList = [posFileList; posFileList2];
clusterFileList = [clusterFileList clusterFileList2];
volList = [volList volList2];
matList = [matList matList2];

% extra stuff for cluster/matrix comps
rangeFileList((length(rangeFileList)+1):2*length(rangeFileList)) = rangeFileList; % double it!
posFileList = regexprep(posFileList,'\.pos',''); % remove pos sufix
posFileList((length(posFileList)+1):2*length(posFileList)) = posFileList; % double it!
% add matrix and cluster file endings
posFileList(1:length(posFileList)/2) = strcat(posFileList(1:length(posFileList)/2),'.matrix.pos');
posFileList((1+length(posFileList)/2):end) = strcat(posFileList((1+length(posFileList)/2):end),'.cluster.pos');

for n = 1:num_files
    posFile = posFileList{n};
    
    posFileM = strcat(regexprep(posFile,'\.pos',''),'_m.mat');
    % check for cached masses
    if(exist(posFileM,'file'))
        % load masses from a file
        % using .m as it is compressed compared to .txt
        disp(strcat('Cached masses:',posFileM));
    else
        if exist(strcat(posFile,'.pos'),'file')
            % open pos file and store masses
            disp('Loading pos file');
        elseif exist(posFile,'file')
            % open pos file and store masses
            disp('Open pos file');
        else
            disp(strcat('**pos file:',posFile,' not found!**'));
        end
    end
end