function clusters = extractStats(rrngFile,posFile,dmaxstr,nmin,coreIons)
% extracts a particular result from a list of cluster stats files
% as generated by DmaxSelection

% get file name
fileNames = {strcat('C:\Users\andy\APT\posgen\',posFile,'c\',rrngFile,'cs',dmaxstr,'_03.txt')};

% data file
fileToRead1 = fileNames{1};
% Import the file
newData1 = importdata(fileToRead1);
%fclose('all');
% Create new variables in the base workspace from those fields.
vars = fieldnames(newData1);
for i = 1:length(vars)
    assignin('base', vars{i}, newData1.(vars{i}));
end
% the above produces colheadings (text), and data (double)

% get the decomposed counts
[elements decomposeCounts] = clusterStatsReader(fileNames{1});

% alloc a results table
nTable = zeros(length(data),1);


% sum up core ions
for c=4:length(textdata) % loop over columns checking for coreAtoms
    %starts at 4, cause the first 3 cols are x,y,z
    for i=1:length(coreIons) % loop over each core ion
        if(strcmp(coreIons{i},textdata{c}))
            % found a match, add to total
            nTable = nTable + data(:,c);
        end
    end
end
% count clusters n >= nmin
count = 0;
for i = 1:length(nTable)
    if(nTable(i)>=nmin)
        count = count + 1;
    end
end
noclusters = count-1;
% store the clusters with n >= nmin
count = 0;
clusters = zeros(count,12);
for cluster=1:length(nTable)
    if(nTable(cluster)>=nmin)
        % store cluster as a result
        clusters(count,1:3) = data(cluster,1:3); % x y z
        clusters(count,4) = nTable(cluster); % no. core atoms
        clusters(count,5) = data(cluster,length(textdata)); % radius
        % get content
        for e=1:length(elements)
            if(strcmp('Y',elements(e)))
                % found Y
                clusters(count,6) = decomposeCounts(cluster,e);
            elseif(strcmp('Ti',elements(e)))
                % found Ti
                clusters(count,7) = decomposeCounts(cluster,e);
            elseif(strcmp('O',elements(e)))
                % found O
                clusters(count,8) = decomposeCounts(cluster,e);
            end
        end
        count = count + 1;
    end
end
% normalise the cluster counts (to percentages)
total = clusters(:,6)+clusters(:,7)+clusters(:,8);
clusters(:,9) = clusters(:,6)./total;
clusters(:,10) = clusters(:,7)./total;
clusters(:,11) = clusters(:,8)./total;
clusters(:,12) = clusters(:,5);
end