function [fitresult, gof] = exp2fit(xx, y, excludes)
%CREATEFIT(XX,Y)
%  Exponential fit using two components
%
%  Data for 'untitled fit 1' fit:
%      X Input : xx
%      Y Output: y
%      excludes is a list of indicies not to fit
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 05-Nov-2015 12:11:39


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( xx, y );

% Set up fittype and options.
ft = fittype( 'exp2' );
opts = fitoptions( ft );
opts.Display = 'Off';
opts.Lower = [-Inf -Inf -Inf -Inf];
opts.StartPoint = [7.86125716173317 0.000235537796265919 10.5841079679529 0.01588251955056];
opts.Upper = [Inf Inf Inf Inf];
ex = excludedata( xData, yData, 'Indices', excludes );
opts.Exclude = ex;

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% % Plot fit with data.
% figure( 'Name', 'untitled fit 1' );
% h = plot( fitresult, xData, yData, ex );
% legend( h, 'y vs. xx', 'Excluded y vs. xx', 'untitled fit 1', 'Location', 'NorthEast' );
% % Label axes
% xlabel( 'xx' );
% ylabel( 'y' );
% grid on


