% example EFTEM PCA factors

% FeY
[data,sc,sc_units,sc_offset,sc_name] = eftemH5_factors('F:\TEM\oj2200\20140709\A1\largeParticle\bss_factors.h5');
FeYx = sc_offset(1)+(1:size(data(4,:),2));
FeYy = data(4,:);

% FeTiY
[data,sc,sc_units,sc_offset,sc_name] = eftemH5_factors('F:\TEM\oj2200\20140615\B05\R4\loadings.h5');
FeTiYx = sc_offset(2)+(1:size(data(3,:),2));
FeTiYy = data(3,:);

% FeCrTiY
[data,sc,sc_units,sc_offset,sc_name] = eftemH5_factors('F:\TEM\oj2200\20140312\C01010\06bulkBottom\factors.h5');
FeCrTiYx = sc_offset(1)+(1:size(data(4,:),2))-1;
FeCrTiYy = data(3,:);

% plot
plot(FeYx,FeYy,FeTiYx,FeTiYy*200,FeCrTiYx,FeCrTiYy*0.004);
xlabel('Energy Loss eV');
ylabel('Loading Arb. units');
legend('FeY','FeTiY','FeCrTiY');

% export data to R
export = [{'EnergyLoss','Loading','Sample'}; ...
    num2cell(FeYx)' num2cell(FeYy)' repmat({'FeY'},size(FeYx,2),1); ...
    num2cell(FeTiYx)' num2cell(FeTiYy*200)' repmat({'FeTiY'},size(FeTiYx,2),1); ...
    num2cell(FeCrTiYx)' num2cell(FeCrTiYy*0.004)' repmat({'FeCrTiY'},size(FeCrTiYx,2),1)];
cell2csv('exampleEFTEM.csv',export);