% testing the equivalence of a sum of erfs as a gaussian:
x = -100:0.1:100;

h = [0.2:0.1:4];
Dt = [0.25:0.1:10];

Dt1 = 2;
h1 = 0.5;

dh = zeros(length(h),2);
dDt = zeros(length(Dt),2);

for i = 1:length(h);
    y=sphereDiffusion(x,h(i),Dt1);
    cfun1 = fit(x', y', 'gauss1');
    dh(i,:) = [cfun1.a1 cfun1.c1];
end

for i = 1:length(Dt);
    y=sphereDiffusion(x,h1,Dt(i));
    cfun1 = fit(x', y', 'gauss1');
    dDt(i,:) = [cfun1.a1 cfun1.c1];
end

subplot(2,2,1)
plot(h,dh(:,1),h, (2.*h)/(Dt1*sqrt(4*pi)))
subplot(2,2,2)
plot(h,dh(:,2),h, 2*Dt1)
%plot(h,dh(:,2),h, 2*Dt1*(1.25-0.25*cos(h*0.4252)))
subplot(2,2,3)
plot(Dt,dDt(:,1),Dt, (2*h1)./(Dt.*sqrt(4*pi)))
subplot(2,2,4)
plot(Dt,dDt(:,2),Dt, 2*Dt)