function [ edClr ] = eposCluster( op,ed )
%[ edClr ] = eposCluster( originalPos,eposData )
%   Takes the original [x' z'] data from a clustered pos file and the [x y
%   z m pulses] from an epos file and searches for the clustered ions from
%   the pos in the epos file. It returns a "clustered" epos file.
nc = size(op,1);
edClr = zeros(nc,5); % x,y,z,m,p
js=1;
tic
for i=1:nc
    if ~rem(i,1000)
        %disp(strcat(num2str(i),'\',num2str(length(x))));
        disp( num2str(((nc-i)/i)*toc/60,3) );
    end
    for j=js:size(ed,1)
        if ed(j,3) == op(i,2) && ed(j,1) == op(i,1)
                edClr(i,:) = ed(j,:);
                js = j;
                break
            end
        end
    end
end
toc
disp('Done epos cluster');
end

