% generate a pos file where the Z coordinate is proportional to the pulse
% number using a pos file and epos file.
%posFile = 'C:\Users\andy\APT\R14_15868 Cr02\recons\recon-v01\default\R14_15868-v01.pos';
eposFile = 'C:\Users\andy\APT\epos\R14_15868-v01';

% read epos
[eposData] = readCachedEpos(eposFile,2);
%  1 2 3 4 5  6   7  8  9  10    column
% [x,y,z,m,nm,vdc,xd,yd,dP,tof]
% sum pulses
np = cumsum(eposData(:,9));
% get conversion factor between Z and NP
c = max(eposData(:,3))/np(end);

% get new z coord:
z = np*c;

% write pos file
[f,n,e]=fileparts(eposFile);
posFile = strcat(f,'\',n,'-np','.pos');

savepos(eposData(:,1),eposData(:,2),z,eposData(:,4),posFile);