function [newFileName] = epos2posFile2(filename)
%[newFileName] = epos2posFile2(filename)

if nargin<1
    [FileName,PathName] = uigetfile('*.epos','Select EPOS file');
else
    [pathstr] = fileparts(filename);
    [FileName,PathName] = uigetfile('*.epos','Select EPOS file',pathstr);
end
FileName = regexprep(FileName,'\.epos','');
% load epos file
[x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos([PathName FileName]);
newFileNameSingle = [PathName FileName '-single.pos'];
newFileNameMulti = [PathName FileName '-multi.pos'];
p = nm~=1;
% make new data
savepos(x(~p),y(~p),z(~p),m(~p),newFileNameSingle);
savepos(x(p),y(p),z(p),m(p),newFileNameMulti);
end