function [newFileName] = epos2posFile(filename)
% [newFileName] = epos2posFile(filename)
% splits a epos file at m/z = splitmz and shows the mutliples as ions with
% m/z = m/z + splitmz
splitmz = 200;
if nargin<1
    [FileName,PathName] = uigetfile('*.epos','Select EPOS file');
else
    [pathstr] = fileparts(filename);
    [FileName,PathName] = uigetfile('*.epos','Select EPOS file',pathstr);
end
FileName = regexprep(FileName,'\.epos','');
% load epos file
[x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos([PathName FileName]);
newFileName = [PathName FileName 'm.pos'];
p = m<splitmz;
m=m(p);x=x(p);y=y(p);z=z(p);nm=nm(p); % crop to splitmz
m(nm~=1) = m(nm~=1) + splitmz;
% make new data
savepos(x,y,z,m,newFileName);
end