function [ionicRangeTab,ionStr,ions]=elemental2ionicRangeTab(elementalRangeTab,elements,ranges)
% [ionicRangeTab,ions]=elemental2ionicRangeTab(elementalRangeTab,elements,ranges)
% Turn an elemental range table (ranges-by-elements), a list of elements
% and the ranges cell (returned by range reader):
% into an ionic range table (ranges-by-ions) and a list of ions. The ions
% are a list of natural names, with charges, and the cell definition of
% ions: YO2++ = {2,'Y',1,'O',2}
% elementalRangeTab should be a matrix and not contain the range
% boundaries, only 0s and integers.
% A London Feb 2015
% calculate charge states
load('isotopes.mat')
a=regexp(isotopes(:,1),'[A-Z](|[A-Z][a-z](','match');
e = regexprep(vertcat(a{:}),'(',''); % strip ( from strings
[es,~,ib]=unique(e,'stable'); % remove duplicates and get list
isotopemasses = zeros(1,length(es));
for i=1:length(es)
    isotopemasses(i) = sum(cell2mat(isotopes(ib==i,2)).*cell2mat(isotopes(ib==i,3)))/100;
end
[~,ie]=ismember(elements,es); % which
emass = isotopemasses(ie);
chargeState = round((elementalRangeTab*(emass'))./cell2double(ranges(:,1)));
unsrtIons = ionTable2ions(elementalRangeTab,elements,chargeState);
ionStr = ions2ionStrChrg(unsrtIons);
[ionStr,ia]=unique(ionStr,'stable');
ionStr = ionStr';
ions = unsrtIons(ia);
elePerIon = elementalRangeTab(ia,:);
% also need to include the charge states from the ranges as a 'key'
[~,loc]=ismember([chargeState elementalRangeTab],[chargeState(ia) elePerIon],'rows');
ionicRangeTab = full(sparse(1:size(elementalRangeTab,1),loc,1));
end