function [ionicRanges,ions] = ele2ionicRanges(rangeTable,elements)
%[ionicRanges] = ele2ionicRanges[rangeTable,elements]
% convert an elemental range table (elements columns, ranges rows) with the
% first and second columns being the range start and end, into an ionic
% range table (1st & 2nd cols untouched) but with "ions" as the columns
% From:
% rangeStart rangeEnd element1 element2 ... elementN
% 0.0        1.0      2        0        ... 0
% To:
% rangeStart rangeEnd ion1 ion2 ... ionN
% 0.0        1.0      1    0    ... 0
% Can take rangeTable as a double or cell, with or without colour and ion
% volume columns, returns in the same format

% rangeTable Type
rtype = 0;
if iscell(rangeTable)
    if ischar(rangeTable{1,4})
        % assume this is the full range inc colour and volume
        volcol = rangeTable(:,3:4); % cell
        rangeTable = cell2mat(rangeTable(:,[1:2 5:end]));
        rtype = 1;
    else
        % assume this is just rangeStart rangeEnd elements...
        rangeTable = cell2mat(rangeTable);
        rtype = 2;
    end
elseif isnumeric(rangeTable)
    % assume this is just rangeStart rangeEnd elements...
else
   error('didn''t recognise the data type of rangeTable');
end
% check for size consistency
if (size(rangeTable,2)-2)-length(elements) ~= 0
   error([num2str(size(rangeTable,2)-2) ' elements in range table, but ' num2str(length(elements)) ' elements supplied']);
end

uions = makeIon(rangeTable(:,3:end),elements)'; % make a list of 'natural names' one for each range
[ions, ~, ci] = unique(uions,'stable'); % get unique list
[ions1, ~, ci1] = unique([uions; elements],'stable'); % get unique list + elements that might be missing
if length(ions1) == length(ions)
    ionicRanges = full(sparse(1:size(rangeTable,1),ci,1)); % set the (range,ionNum) = 1 for each range, assuming only one ion per range
    % Warning! assumes a single ion per range, this can be changed by using the
    % 3rd argument given to sparse above        ^
else
    % need to add another dummy range to the ionic range table
    % how many are missing?
    missingEles = length(ions1) - length(ions);
    for i = 1:missingEles
       rangeTable(end+1,1:2) = [0 0]; % range is 0-0
       if rtype == 1
          volcol(end+1,1:2) = [{0} {'000000'}]; % zero for vol and colour
       end
       % assuming the element is defined somewhere
       misE = ions1{missingEles+length(ions)}; % missing element
       if sum(strcmp(misE,elements))
           rangeTable(end,3:end) = (strcmp(misE,elements)); % set element content
       else
           error(['Could not find element:' ions1{missingEles+length(ions)}]);
       end
    end
    % try again
    uions = makeIon(rangeTable(:,3:end),elements)'; % make a list of 'natural names' one for each range
    [ions, ~, ci] = unique(uions,'stable'); % get unique list
    ionicRanges = full(sparse(1:size(rangeTable,1),ci,1));
end
if rtype == 0
    ionicRanges = [rangeTable(:,1:2) ionicRanges]; % numeric
elseif rtype == 1
    ionicRanges = [num2cell(rangeTable(:,1:2)) volcol num2cell(ionicRanges)]; % cell inc colour and vol
elseif rtype == 2
    ionicRanges = [num2cell(rangeTable(:,1:2)) num2cell(ionicRanges)];  % cell
end
end