function [data,sc,sc_units,sc_offset,sc_name] = eftemH5_factors(fileName)
%[data,sc,sc_units,sc_offset,sc_name] = eftemH5_factors(fileName)
% reads the h5 produced from hyperspy 7.3 when you save an EFTEM factors
% (line profiles) as an h5 file.
% This assumes a certain layout and I have no idea how robust
% it is! Good luck.
% Returns: [n x m] data, rows are 
% the scale values (double) and:
% scale_units (eg eV or factor)
% scale_offset for each scale
% names of the scales (sc_name) eg "Energy Loss" or "Factors"
if ~exist(fileName,'file')
    error(['No file: ' fileName ' found']);
end
a=h5info(fileName);
scaleGroups1 = {a.Groups.Groups.Groups.Attributes};
% number of scales, first read all of of the first "sub-group"
scaleGroups2 = ~cell2mat(cellfun(@isempty,scaleGroups1,'uni',0));
scaleGroups3 = find(scaleGroups2); % index positions eg [1 2 3]
scaleNum = sum(scaleGroups2);
if scaleNum ~= 2
    error(['Found ' scaleNum ' scales when 2 were expected']);
end
sc = zeros(scaleNum,1);
sc_units = cell(scaleNum,1);
sc_size = zeros(scaleNum,1);
sc_offset = zeros(scaleNum,1);
sc_name = cell(scaleNum,1);
for i = 1:scaleNum
    % assuming Attributes(1 to 5) are: {'scale';'name';'offset';'units';'size'}
    names = {a.Groups.Groups.Groups(scaleGroups3(1)).Attributes.Name};
    sc_name(i) = a.Groups.Groups.Groups(scaleGroups3(i)).Attributes(strcmp(names,'name')).Value;
    sc(i) = a.Groups.Groups.Groups(scaleGroups3(i)).Attributes(strcmp(names,'scale')).Value;
    sc_units(i) = a.Groups.Groups.Groups(scaleGroups3(i)).Attributes(strcmp(names,'units')).Value;
    sc_size(i) = a.Groups.Groups.Groups(scaleGroups3(i)).Attributes(strcmp(names,'size')).Value;
    sc_offset(i) = a.Groups.Groups.Groups(scaleGroups3(i)).Attributes(strcmp(names,'offset')).Value;
end
data1 = h5read(fileName,[a.Groups.Groups.Name '/' a.Groups.Groups.Datasets.Name]);

% flip n and m dimensions
data = data1';

end