function [data,sc,sc_units] = eftemH5(fileName)
%[data,sc,sc_names] = eftemH5(fileName)
% reads the h5 produced from hyperspy 7.3 when you save an EFTEM series as
% an h5 file. This assumes a certain layout and I have no idea how robust
% it is! Good luck.
% Returns: [n x m x k] data, the scale values (double) and the scale_units
if ~exist(fileName,'file')
    error(['No file: ' fileName ' found']);
end
a=h5info(fileName);
scaleGroups1 = {a.Groups.Groups.Groups.Attributes};
% number of scales, first read all of of the first "sub-group"
scaleGroups2 = ~cell2mat(cellfun(@isempty,scaleGroups1,'uni',0));
scaleGroups3 = find(scaleGroups2); % index positions eg [1 2 3]
scaleNum = sum(scaleGroups2);
if scaleNum ~= 3
    error(['Found ' scaleNum ' scales when 3 were expected']);
end
sc = zeros(scaleNum,1);
sc_units = cell(scaleNum,1);
for i = 1:sum(scaleGroups2)
    % assuming Attributes(1 to 5) are: {'scale';'name';'offset';'units';'size'}
    names = {a.Groups.Groups.Groups(scaleGroups3(1)).Attributes.Name};
    sc(i) = a.Groups.Groups.Groups(scaleGroups3(i)).Attributes(strcmp(names,'scale')).Value;
    sc_units(i) = a.Groups.Groups.Groups(scaleGroups3(i)).Attributes(strcmp(names,'units')).Value;
end
data1 = h5read(fileName,[a.Groups.Groups.Name '/' a.Groups.Groups.Datasets.Name]);
% rehsape rows and cols, assuming y,x,z ordering of axes
data1 = reshape(data1,[size(data1,2) size(data1,1) size(data1,3)]);
data = zeros([size(data1,2) size(data1,1) size(data1,3)]);
% flip n and m dimensions
for z = 1:size(data1,3)
    data(:,:,z) = data1(:,:,z)';
end
end