% convert from loading or factors .h5 to image
fileName = 'F:\TEM\oj2200\20140615\C010\R1\factors.h5';
%fileName = 'F:\TEM\oj2200\20140312\C01010\06bulkBottom\bss_loadings.h5';
fileOut = '20140614-C010-R1-f2-b.png'; % only works with .png
%fileOut = '20140312-C01010-06bulkBottom-3.png';
index = 2; % as in the image file name eg. factor_02 = 2

contrastLimits = [2000 -500]; % leave empty for automatic [];

% read file
[data,sc,sc_units] = eftemH5(fileName);
d = data(:,:,index+1);
% set limits?
if isempty(contrastLimits)
    contrastLimits = [max(d(:)) min(d(:))];
end
imagesc(max(min(d,contrastLimits(1)),contrastLimits(2)));

% set up image
colormap('gray')
set(gca,'XTick',[]) % Remove the ticks in the x axis!
set(gca,'YTick',[]) % Remove the ticks in the y axis
set(gca,'Position',[0 0 1 1]) % Make the axes occupy the hole figure
axis equal tight
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 size(d,2) size(d,1)]/100)
% save image
eval(['print -dpng ' fileOut ' -r100'])
winopen(fileOut)