% eftem load h5 files and save as factored (in the R sense) csv files

%% factors (line profiles)
fileName='F:\TEM\oj2200\20130930\B2LiftOut\Region12\factors.h5';
fileOut='F:\TEM\oj2200\20130930\B2LiftOut\Region12\factors9.csv';
num_factors = 9;
[data,sc,sc_units,sc_offset,sc_name] = eftemH5_factors(fileName);

data1=data(1:num_factors,:)';
data2=reshape(data1,[],1);
data3= [repmat((0:size(data1(:,1))-1)'+sc_offset(1),num_factors,1) data2 floor((0:(size(data2,1)-1))/size(data1,1))'+1];
cell2csv(fileOut,[{'energy', 'value','factor'};num2cell(data3)]);

%% loadings (images)
fileName='F:\TEM\oj2200\20130930\B2LiftOut\Region12\loadings.h5';
fileOut='F:\TEM\oj2200\20130930\B2LiftOut\Region12\loadings9.csv';
[data,sc,sc_units]=eftemH5(fileName);

[X,Y]=meshgrid(0:sc(1):(sc(1)*size(data,1)-1),0:sc(1):(sc(2)*size(data,2)-1));
xy = [reshape(X,[],1) reshape(Y,[],1)];
clear X Y
l = size(xy,1); % "length" of each image
dataOut = zeros(l*num_factors,4);
dataOut(:,1:2) = repmat(xy,num_factors,1);
dataOut(:,4) = floor(((1:(l*num_factors))-1)/l)+1;
for i = 1: num_factors
    A = reshape(data(:,:,i),[],1);
    % normalise the data to [0,1]
    dataOut( ((i-1)*l + 1) : i*l ,3) = (A - min(A(:)))/(max(A(:)) - min(A(:)));
end
    
cell2csv(fileOut,[{'x','y','value','factor'};num2cell(dataOut)]);