function [iList]=editColours(iList)
% takes a list (iList) = 
%{'Ion1' color(hex) ionVolume} by n rows
% and modifies specific colours as defined here
% corrections = {'ion1','newColour','ion2', etc}
corrections = {'Y','0000FF','C','660033','C2','660033','C3','660033',...
    'C4','660033','Fe2O','FF0099','FeO','FF0000','O2','FF0000',...
    'TiO','00CC00','TiO2','00CC00','Ti','00FF00','YO','0000FF',...
    'YO2','0000FF'};
cIons = corrections(1:2:end);
cCols = corrections(2:2:end);
for i = 1:size(iList,1)
    p = strcmp(iList{i,1},cIons);
    if sum(p)
       iList(i,2) = cCols(p);
    end
end
end