function [edgeClusterList]=edgeClusters(clusterFile,posFile)
% detect edge clusters from pos file and cluster file (IVAS)
draw = 0; % draw a picture or not? 1/0
sliceThick = 0.2; % slice thickness in nm
%clusterFile = 'R14_15065-v04_Y_YO_09_10.csv';
%posFile= 'C:\Users\Andy\APT\R14_15065 FeYTi_ex\recons\recon-v04\default\R14_15065-v04.pos';
% load cluster file
[elements,countsDecomp,counts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterFile);
% load pos file
[x,y,z,~]=readpos(posFile);
edgeList = zeros(size(extentZ));
for i=1:count
    % go to cluster centre (z)
    % get slice of pos data
    p = z>(position(i,3)-sliceThick/2) & z<(position(i,3)+sliceThick/2);
    pslice = [x(p)' y(p)'];
    % get COM
    com = [(max(pslice(:,1))+min(pslice(:,1)))/2 (max(pslice(:,2))+min(pslice(:,2)))/2];%mean(pslice,1);
    % get radii
    r = sqrt(sum((pslice-repmat(com,[size(pslice,1) 1])).*(pslice-repmat(com,[size(pslice,1) 1])),2));
    [sliceR,ri] = max(r);
    % estimate of outer radius 1
    [n,rn] = hist(r,50);
    % 2D radius of gyration iss too big
    %rxy = sqrt(sum( (pslice(:,1)-mean(pslice(:,1))).^2 + (pslice(:,2)-mean(pslice(:,2))).^2)/size(pslice,1) );
    if draw
        % draw circle
        scatter(pslice(:,1),pslice(:,2),'m.')
        viscircles(com,max(r),'edgecolor','red');
        viscircles(com,rn(n==max(n)),'edgecolor','green');
        %viscircles(com,rxy*sqrt(5/2),'edgecolor','blue');
        viscircles(position(i,[1 2]),extentZ(i),'edgecolor','blue');
        axis equal
        pause
    end
    % find distance from edge
    cr = pdist([position(i,[1 2]); com]); % cluster-centre dist
    % compare to cluster radius (extent or rg)
    % decide if edge or not
    if (cr+extentZ(i))>rn(n==max(n))
        % exclude cluster
        edgeList(i) = 1;
    end
end
edgeClusterList = find(edgeList);
% edge percentage:
disp(['Edge percentage:',num2str(100*sum(edgeList)/length(extentZ))]);
end