function [y] = dpa_fit_5MeV(x2, v2)
%CREATEFIT(X2,V2)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input : x2
%      Y Output: v2
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 25-Jul-2014 12:58:05


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( x2, v2 );

% Set up fittype and options.
ft = fittype( 'smoothingspline' );
opts = fitoptions( ft );
opts.SmoothingParam = 6.5680355753413e-10;

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, xData, yData );
legend( h, 'v2 vs. x2', 'untitled fit 1', 'Location', 'NorthEast' );
% Label axes
xlabel( 'x2' );
ylabel( 'v2' );
grid on
y = fitresult.p.coefs(:,4);

