% script for drawing DPA-depth lines on APT images

iroot = 'C:\users\andy\APT\'; % image file root
spacing = 5; % number of dpa measurements to show on image
% get files
[outputData,cols]=dataBase('run>0');
% return runs that have images associated:
outputData=outputData(cellfun(@isstr,outputData(:,strcmp('img',cols))),:);

% get dpa-depth
% if C1,2,3, B1,2,3 or A1 then 5MeV [1], C010,10,H 1.76MeV [2] otherwise [0]
mats = {{'A1','B1','B2','B3','C1','C2','C3'},{'C010','C010H','C01010','B010','B010H','B01010'}};
% need to include the C05 and B05 codes too...
energies = {'5MeV','1760keV'};  % otherwise 0
energyFiles = {'dpa5MeV.mat','dpa1760keV.mat'}; % depth-dpa files
e = zeros(size(outputData,1),1); % which ion for which sample code
for m=1:length(mats)
    for j = 1:length(mats{m})
        e = e + strcmp(outputData(:,strcmp('mat',cols)),mats{m}{j})*m;
    end
end

for i=1:length(outputData(:,1))
    
    if e(i)>0 % if irradiated
        % get dpa data: 
        load(energyFiles{e(i)}); % load (x and dpa)
        % load image
        [I,map] = imread(strcat(iroot,outputData{i,strcmp('img',cols)}));
        % draw depth scale
        imshow(I,map);
        title(num2str(outputData{i,strcmp('run',cols)}));
        % specify scale
        [ix,iy]=ginput(2); % pick the low and high points on the Z-scale of the image
        % input z-values
        d1 = input('Depth1 (smallest):', 's');
        d2 = input('Depth2:', 's');
        d1 = str2double(d1);d2 = str2double(d2);
        % specify offset from the surface (nm)
        d0 = outputData{i,strcmp('depth',cols)};
        if isnan(d0)
            d0 = input('Depth from original surface (nm)?', 's');
            d0 = str2double(d0);
        end
        % get scaling
        s = (d2-d1)/(ix(1)-ix(2)); % nm per pix
        % set dpa spacing
        depths = d0+(d2-d1).*((0:(spacing-1))/(spacing-1));
        dpas = round(interp1(x,dpa,depths));
        % draw text
        for j=1:length(dpas)
           text(ix(1)+(ix(2)-ix(1))*(j-1)/(length(dpas)-1),mean(iy),num2str(dpas(j)));
        end
        % render image
        pause
        % save image
    end
end