% after running dmax_variation run this to process the datato use in R
newNmin = 75; % set the nmin
p = cellfun(@(x) (x>newNmin),nTable,'uni',0);
if(0)
n = cell2mat(cellfun(@(x) sum(x>newNmin),nTable,'uni',0));
a = cellfun(@(x,y) sum(x(y,:),1), countsDecomp,p, 'uni',0);
composition = vertcat(a{:});
N = sum(composition,2);
composition = composition./repmat(N,1,size(composition,2));
% matrix correction:
fe = composition(:,strcmp('Fe',elements));
cr = strcmp('Cr',elements);
comp2 = composition;
comp2(:,strcmp('Fe',elements)) = 0;
comp2(:,cr) = composition(:,cr)-0.13*fe;
compCorrected = comp2./repmat(sum(comp2,2),1,size(comp2,2));
plot(dselection,compCorrected(:,2:5));legend(elements(2:5));
meanRadius = cell2mat(cellfun(@mean,rg,'uni',0));
exportResults = [dselection' n meanRadius];
exportResults = [{'dmax','n','r'}; num2cell(exportResults)];
exportComp = [{'dmax'} elements(1:5); num2cell([dselection' composition(:,1:5)])];
exportCompCor = [{'dmax'} elements(2:5); num2cell([dselection' compCorrected(:,2:5)])];
cell2csv('methods-dmax-variation1.csv',exportResults);
cell2csv('methods-dmax-variation2.csv',exportComp);
cell2csv('methods-dmax-variation3.csv',exportCompCor);
end
% solute fraction histograms:
X=0:0.05:1;
soluteFrac = cellfun(@(x,p) sum(x(p,3:5),2)./sum(x(p,:),2),countsDecomp,p,'uni',0);
soluteHist = cellfun(@(x) hist(x,X),soluteFrac,'uni',0);
soluteHist2 = vertcat(soluteHist{:});
%figure;plot(X,cumsum(soluteHist2(1:5:end,:)'));
%legend(cellfun(@(x) sprintf('%2.2f',x),num2cell(dselection(1:5:end)),'uni',0));
figure;plot(X,cumsum(soluteHist2(1:2:end,:)'));
legend(cellfun(@(x) sprintf('%2.2f',x),num2cell(dselection(1:2:end)),'uni',0));