% dmax settings variation
% runs a number of cluster searchs and returns the variation in the
% measured properties: composition, size, number, solute fraction
 
rrngFile = 'C:\Users\andy\APT\17183_80.rrng';
posFile = 'C:\Users\andy\APT\R14_17183\recons\recon-v01\default\R14_17183-v01.pos';
%posFile = 'C:\Users\andy\APT\R14_17183\recons\recon-v01\default\R14_17183-v01.matrix.pos';

% Set posgen dir
posDir = 'C:\Users\andy\APT\posgen\';
% copy rrng file to posgen dir
%cpy(rrngFile,posDir);
% copy pos file to posgen dir
%cpy(posFile,posDir);
cd(posDir);
% Run cluster search
% Generate clusterOps.xml file:
[~,rrngName,rrngExt]= fileparts(rrngFile);
[~,posName,posExt]= fileparts(posFile);

dselection = 0.5:0.02:1.1;
countsDecomp = cell(length(dselection),1);
counts = cell(length(dselection),1);
position = cell(length(dselection),1);
ionType = cell(length(dselection),1);
rg = cell(length(dselection),1);
nTable = cell(length(dselection),1);
soluteContent = cell(length(dselection),1);

for d = 1:length(dselection)
    dmax = num2str(dselection(d));%'0.7';
    dbulk = dmax; % set to zero to skip, time saver!
    nmin = '8';
    core = {'YO' 'TiO' 'Y' 'O'};
    statsFile = strcat(rrngList{1},'clustered',regexprep(dmax,'.','_'),'.txt');
    disp('Generating posgen options xml file');
    posgenOptionGen('ops.xml',strcat(posName,posExt),strcat(rrngName,rrngExt),dmax,'1',dbulk,'0',nmin,core,statsFile,0,0,0,0);
   
    % Run posgen
    disp('Running posgen');
    returncode = unix('posgen ops.xml');
    if returncode ~=0
        error('posgen died')
    end
    % get results (read statsFile)
    disp('Reading clustered stats file');
    [elements, countsDecomp{d},counts{d},position{d},ionType{d},rg{d}, nTable{d}] = clusterStatsReader(statsFile, core);
    p =  strcmp(elements,'Y')|strcmp(elements,'O')|strcmp(elements,'Ti');
    soluteContent{d} = sum(countsDecomp{d}(:,p),2)./sum(countsDecomp{d},2);
end
