% particle distribution FIB cutting experiment (only face simulated)

length = 2000; % dimentions of simulation face
density = 4.29E-4; % per volume
n = round((density^(2/3))*length^2);
mu = 20;
sigma = .01;

disp(strcat('density =',num2str(density,'%4.3e'),'/vol'));
particles = length*rand(n,2);
sizes = normrnd(mu,sigma,n,1);
sizes(sizes<0) = 0;
particles(:,4) = sizes;
particles(:,3) = (-1+2*rand(n,1)).*particles(:,4);

% slice at:
%z = 0;

clf
subplot(2,2,[1 3])
hold on
count = 0;
obs = 0;
for i = 1:n
    % observed sizes of the particles
    % fraction of particles intersecting:
    if(rand<(particles(i,4)/length))
        slice = real(sqrt((particles(i,4) - particles(i,3)).*(particles(i,4) + particles(i,3))));
        if(slice>0.01)
            circle(particles(i,1),particles(i,2),slice);
            %disp(slice(i));
            count = count +1;
            obs(count)=slice;
        end
    end
end
disp(count);
disp('expected');
disp(density);
disp('observed');
disp((count/(length^2))^(3/2))
xlim([0 length]);ylim([0 length]);axis square;
hold off
subplot(2,2,2); title('Actual');
hist(particles(:,4));
subplot(2,2,4); title('Observed');
hist(obs);
disp(mean(obs)/mean(particles(:,4)));