%function ratio = distSim()
% particle distribution FIB cutting simulation (full depth)

length = 1000; % dimentions of simulation face
depth = length; % simulated depth
volume = depth*(length^2); % in cubic meters
density = 4E-5; % per volume
n = round(density*volume);
mu = 20;
sigma = .01;

disp(strcat('density =',num2str(density,'%4.3e'),'/nm3'));
particles = length*rand(n,2);
particles(:,3) = depth*rand(n,1);
sizes = normrnd(mu,sigma,n,1);
sizes(sizes<0) = 0; % remove negative radii
particles(:,4) = sizes;
% slice at:
z = 0.2*depth;
% observed sizes of the particles
slice = real(sqrt((particles(:n,4) - (particles(:,3)-z)).*(particles(:,4) + (particles(:,3)-z))));
clf
subplot(2,2,[1 3])
hold on
count = 0;
obs = 0;
for i = 1:n
    if(slice(i)>=-particles(i,4))
        if(slice(i)<=particles(i,4))
            if(slice(i)>0.01)
            circle(particles(i,1),particles(i,2),slice(i));
            %disp(slice(i));
            count = count +1;
            obs(count)=slice(i);
            end
        end
    end
end
disp(count);
disp('expected');
disp(density);
disp('observed');
disp((count/(length^2))^(3/2))
xlim([0 length]);ylim([0 length]);axis square;
hold off
subplot(2,2,2); title('Actual');
hist(particles(:,4));
subplot(2,2,4); title('Observed');
hist(obs);
disp(mean(obs)/mean(particles(:,4)));
ratio = density/((count/(length^2))^(3/2));
%end