function [DthY] = diffusionofYinFe(Cv,T)
%[DthY] = diffusionofYinFe(Cv,T)
% estimate the diffusion coefficient of Y in Fe given the vacancy
% concentration and temperature (in K)
% If Cv = 0, then the equilibrium vacancy conc is used
% Diffusion equation used from [C. Hin, B.D. Wirth J Nucl Mater, 402 (2010), p. 30]
EfV = -2.2; % Actiavation energy of vacancy formation eV
kB = 0.00008617332478; % Boltzman Const.
CvTh = exp(EfV./(kB*T)); % thermal eq. vacancy conc. in Iron
if Cv == 0
    % use eq Cv
    Cv=CvTh;
end

DthY = 0.1.*exp(-3.25./(kB.*T)).*Cv./CvTh; % in cm^-2 s^-1
%DthY = Cv.*0.1.*exp(-3.25./(kB.*T))/10000; % in m^-2 s^-1