function [DthTi] = diffusionofTiinFe(Cv,T)
%[DthY] = diffusionofYinFe(Cv,T)
% estimate the diffusion coefficient of Ti in Fe given the vacancy
% concentration and temperature (in K)
% If Cv = 0, then the equilibrium vacancy conc is used
% Diffusion equation used from [P. KLUGKIST and CHR. HERZI phys. stat. sol.
% (a) 148, 413 (1995)]
EfV = -2.2; % Actiavation energy of vacancy formation eV in Fe
kB = 0.00008617332478; % Boltzman Const.
CvTh = exp(EfV./(kB*T)); % thermal eq. vacancy conc. in Iron
if Cv == 0
    % use eq Cv
    Cv=CvTh;
end
DthTi = zeros(size(T));
for i = 1:length(T)
    if T(i) < 1050
        % use magnetic formula
        DthTi(i) = 9841*exp(-46590/T(i));
    else
        % use non-magnetic formula
        DthTi(i) = 0.21*exp(-35282.8/T(i));
    end
end
DthTi = DthTi.*Cv./CvTh; % account for irradiation enhancement m2/s
DthTi = DthTi*10000; % convert to cm2/s