%% diffusion simulation by MC
%% create block of material
%mat = ones(10000,1)*0;
% mat(1:round(end/4)) = 1000;
% mat(round(3*end/4):end) = 1000;
%mat(round(4.995*end/10):round(5.005*end/10)) = 2000;
mat=round(normpdf(1:10000,5000,20)*10000)';
%mat(1:round(3*end/10)) = 2000;
mat0= mat;
reps = 10000000; % main loop
superReps = 100; % super loop, total reps = reps*superReps
saveReps = [1 10 20 25 50 75 100:10:200];
saveData = cell(length(saveReps),2);
saveIndex = 1;
binby = 4;
% dt = ones(size(reps));%cos(rand(reps,1)*2*pi); % random displacement angle
% dnn = round(dnn.*dt); % project along z-axis
%% main loop
for j = 1:superReps
    disp([num2str(j) '/' num2str(superReps)]);
    nn = ceil(rand(reps,1)*length(mat)); % atoms to move
    dnn = round(randDoubleExp(reps,1,50));
    %dnn = round(randn(reps,1)*50); % distances to move
    %dnn = round(rand(reps,1))*2-1; % distances to move
    for i = 1:reps
        %% pick "atom"
        n = nn(i);
        %n = ceil(rand(1)*length(mat));
        dni = mod(n+dnn(i)-1,length(mat))+1; % wrap around
        if mat(n)>=1
            mat(n) = mat(n) - 1;
            %% move it by a distance described by a function
            mat(dni) = mat(dni) + 1;
        elseif mat(dni)>=1
            mat(n) = mat(n) + 1;
            mat(dni) = mat(dni) - 1;
        end
        %% repeat
    end
    if j == saveReps(1)
        [x,y]=binXY([1:length(mat)]',mat,binby);
        x1=x;y1=y;
        saveData{saveIndex,1} = x;
        saveData{saveIndex,2} = y;
        saveIndex = saveIndex+1;
    elseif sum(j == saveReps(2:end))
        [x,y]=binXY([1:length(mat)]',mat,binby);
        x1=[x1 x];y1=[y1 y];
        saveData{saveIndex,1} = x;
        saveData{saveIndex,2} = y;
        saveIndex = saveIndex+1;
    end
end
%% plot
%[x,y]=binXY([1:length(mat)]',mat,50);plot(x,y/50)
 semilogy(x1,y1/binby)
 xlabel('Distance nm');
ylabel('No. atoms')