function files = dependencies(targetFile)
% list the dependencies of a function
oldLength = 0;
bigList = getDeps(targetFile);
while length(bigList) ~= oldLength
    oldLength = length(bigList);
    for i=1:length(bigList)
        smallList = getDeps([bigList{i} '.m']);
        bigList = unique([bigList; smallList]);
    end
end
files = bigList;
end

function files = getDeps(targetFile)
% get list of matlab functions in path:
listing = dir('*.m');
names = {listing.name}';
names = regexprep(names,'\.m','');
deps = zeros(length(names),1);
fid = fopen(targetFile);
tline = fgets(fid);
while ischar(tline)
    tline = fgets(fid);
    for i = 1:length(names)
        found = strfind(tline,names{i});
        if ~isempty(found)
           deps(i) = 1; 
        end
    end
end
fclose(fid);
files = names(logical(deps));
end