function deconvDisplay(rangeTableDecomp,elements)
%deconvDisplay(rangeTableDecomp,elements)
%Detects non-integer entries (ie where there are overlaps) in a given range
%table and displays the result in the command window

for r = 1:length(rangeTableDecomp(:,1))
    % detect non-integer entries (where there are overlaps)
    intRow = (rangeTableDecomp(r,3:end)-round(rangeTableDecomp(r,3:end)))~=0;
    if sum(intRow)
        disp(['Range:' num2str(rangeTableDecomp(r,1:2),'%2.2f ')]); % range
        disp(elements(rangeTableDecomp(r,3:end)~=0)); % elements
        disp([sprintf('\t'),num2str(rangeTableDecomp(r,logical([0 0 rangeTableDecomp(r,3:end)~=0])),'%6.2f ')]); % percentages
    end
end
end