% update the database with a column containing the clusters defined as
% touching the edge (using edgeClusters.m)
cfRoot = 'C:/Users/andy/APT/clusterAnalysis/';
[data,colNames] = dataBase('run>0',0); % get all data
edgeClrCol = find(strcmp(colNames,'edgeClrs')); % edge cluster column
cfCol = find(strcmp(colNames,'cf')); % cluster file column
indexedRngCol = find(strcmp(colNames,'reconRoot')); % .indexed.rrng column
clrNo = find(strcmp(colNames,'clusterNo')); % number of clusters
for i=1:size(data,1)
    if data{i,end}
        if isempty(data{i,edgeClrCol}) % doesn't alreaddy exist
            if data{i,clrNo}>0 % has clusters
                % usable data set, so get edge clusters
                [mat,idx]=regexp(data(i,indexedRngCol),'[\w\\\:\s\-\.]+(?<=\-v0\d)');
                posFile =  strcat(data{i,indexedRngCol}(1:idx{1}),'.pos');
                data{i,edgeClrCol} = edgeClusters([cfRoot data{i,cfCol}],posFile);
                % save db
                save('data.mat','data')
            end
        end
    else
        % not usable, set to nan
        data{i,edgeClrCol} = NaN;
    end
end