% update the database with a column containing the number of clusters
% counted from the cluster analysis file (.csv) exported from IVAS
cfRoot = 'C:/Users/andy/APT/clusterAnalysis/';
[data,colNames] = dataBase('run>0',0); % get all data
cfCol = find(strcmp(colNames,'cf')); % cluster file column
indexedRngCol = find(strcmp(colNames,'reconRoot')); % .indexed.rrng column
clrNo = find(strcmp(colNames,'clusterNo')); % number of clusters
for i=1:size(data,1)
    if data{i,end} % usable flag == 1
        % get number of clusters from clr file
        [~,~,~,~,~,cfCount,~] = clusterSettingsNumeric([cfRoot data{i,cfCol}]);
        % get number of clusters from indexed rrng file
        [~, rrngCount, ~, ~] = rangeReader (data{i,indexedRngCol});
        if cfCount==rrngCount
            data{i,clrNo} = cfCount;
        else
            disp(['Indexed file and cluster file dont match' num2str(cfCount) '/' num2str(rrngCount)]);
        end
    end
end