%Script for filling in the data.mat database file.
% This script does some ranging using the rangeCorrector function to make
% FW0.2M ranges and count the number of ions in the original file and the
% 20% ranged file. It also computes the density of ions/nm3 from the
% volumes in the data.mat file.

% get data file
[d,colNames]=dataBase('run>0',1); % get all usable data in the database
optiLevel = 0.8; % FW0.2M = 0.8 level
fileRoot = 'C:\Users\Andy\APT\';
rCol = strcmp(colNames,'rrng'); % column with range files in it
clrFileCol = strcmp(colNames,'cf'); % column with cluster rrng file paths in
runCol = strcmp(colNames,'run'); % column of run numbers in data.mat
vCol = strcmp(colNames,'version'); % version number column
rangeList = d(:,rCol);
rangeFileList = strcat(fileRoot,rangeList);
% get pos file list
posFileList = cell(size(d,2),1);
for i = 1:size(d,1)
    [pathstr, name, ext] = fileparts(d{i,clrFileCol});
    posFileList{i} = strcat(pathstr,'\R14_',num2str(d{i,runCol}),'-v',sprintf('%02.0f', d{i,vCol}),'.pos');
end
pause
for i = 1:length(rangeList)
    if exist(strcat(regexprep(rangeFileList{i},'.rrng',''),'_80.rrng'),'file')||exist(strcat(fileRoot,num2str(d{i,runCol}),'_80.rrng'),'file')
        %disp(strcat('Found:',strcat(regexprep(rangeFileList{i},'.rrng',''),'_80.rrng')));
        disp('Exisiting _80.rrng file found');
    else
        disp(strcat('Running range optimiser for:',rangeFileList{i}));
        result = rangeCorrector(rangeFileList{i},posFileList{i},optiLevel);
    end
% rangePlotter(strcat(regexprep(rangeFileList{i},'.rrng',''),'_80.rrng'),posFileList{i});
% pause
end