% dbGetDepth script to find the total depth(z) of each of the reconstructions
% in the data base

[d,cols] = dataBase('run>0',0);

% get all files that have been reconstructed:
reconRoot = d(:,strcmp('reconRoot',cols));
posFile = d(:,strcmp('pos',cols));

% get recon root
posFiles = cell(size(d,1),5);
posFiles(:,1) = d(:,strcmp('run',cols));
posFiles(:,3) = d(:,strcmp('position',cols));
posFiles(:,4) = d(:,strcmp('depth',cols));

for i = 1:size(d,1)
    if posFile{i}
        posFiles{i,2} = posFile{i};
        try
            fileInfo = dir([reconRoot{i} posFiles{i,2}]);
            fileSize = fileInfo.bytes;
            %[x,y,z,~] = readpos([reconRoot{i} posFiles{i,2}]); % whole
            %file
            % read only .99 (99%) of the file instead:
            [x,y,z,~]=readpospart([reconRoot{i} posFiles{i,2}],round(.99*(fileSize/16)),fileSize/16);
            posFiles{i,5} = max(z(x<1 & x>-1 & y<1 & y>-1));
            clear x y z
        catch err
            disp('couldn''t open pos file');
            posFiles{i,5} = 'couldn''t open pos file';
        end
    end
end
