% Using the peak damages in irrdDpa1 make a new column of irradiation
% energy that can be used with SRIM

[d,cols] = dataBase('run>0',0); % load only usable data
d(cellfun(@isempty,d))={NaN};
clusterFiles = d(:,strcmp('cf',cols));
irrdDpa1 = cell2mat(d(:,strcmp('irrdDpa1',cols))); % peak damage of 1st irrd treatment

energies = {'5MeV','1760keV','1760keV'};  % otherwise 0
peakDpas = {150,100,50};
energyFiles = {'dpa5MeV.mat','dpa1760keV.mat','dpa1760keV.mat'}; % depth-dpa files

e = zeros(size(d(:,1)));
e = num2cell(e);
for i = 1:length(energies)
    e(irrdDpa1==peakDpas{i}) = energies(i);
end