function [outputData,cols]=dataBase(string,usableFlag)
%[outputData,columnNames]=dataBase(string,usableFlag)
%Returns info from data.mat based on the args (string) provided.
% Example: dataBase('usable==1') returns all usable datasets.
% 'mat==C3' returns all samples with the C3 mat code.
% Allowed operators: == != > >= < <=
% == and != only work with string fields
% columns in data.mat:
%cols = {'run','matCode','mat','irrdT1','irrdDpa1','irrdT2','irrdDpa2',...
%  'position','version','vol','spec','ionDens','nDens','80ranged',...
%  'ranged','images','depth','dpa','clusterNo','laser','freq','temp','ionE',...
%  'notes','cf','reconRoot','pos','clrIdxRrng','img','rrng','edgeClrs',...
%  'startSkip','usable';}
% cols is now stored in the data.mat file and returned
% run,sample,position (eg coupon3 post 6) ,version,volume nm3,spectrum
% count, density, particle density, FW0.2M ranged, ranged percentage, images,
% sample depth, start dpa, no. clusters, laser power, freq, temp, ion energy 
% used for the irradiation,notes, cf (clusterFile), reconstructionRoot, 
% image file, rrng file, edge clusters list, usable flag (0/1)
% startSkip = fraction of file to skip which contains surface oxide
% Todo: allow string to be a cell of multiple strings and parse multiple
% operations
% line 35 = an example of column data types
% {16915,'C1','FeCrTiY',773,150,[],[],'coup1 8',2,155260,15E6,96,...
% 5.35e+23,7E6,49,'39, C1_001, 2,  15, coupon1069',0,25,83,0.30,250,50,...
%'mini-fracture','R14_16915-v02_YYOOTiO_80.csv',...
% 'C:\Users\Andy\APT\R14_16915\recons\recon-v02\default\',...
% 'R14_16915-v02.pos',...
% 'C:\Users\Andy\APT\R14_16915\recons\recon-v02\default\R14_16915-v02.cluster.indexed.rrng',...
% '16915.PNG','16915.rrng',[<34x1 double>' char(10) '],1;}
% A London July 2014

% need to add cluster files, pos locations etc to this

% get database data
load('data.mat','data','cols'); % loads 'data' and 'cols'

% complete row (don't change this!) used to get data type str/num
rt = 35;
% get options
if ~exist('usableFlag','var')
    usableFlag = 0;
end
% get item names
items = regexp(string,'(\w+)','match');
if length(items)~=2
    error('badly formed input');
end
oper = regexp(string,'(\w+)','split');
if length(oper)~=3
    error('badly formed input');
end
oper = oper{2}; % operation to perform

c = strcmp(cols,items{1});
% check item exists in the column name list
if ~sum(strcmp(cols,items{1}))
    error(strcat('Could not find:',items{1},' in column name list'));
end

%get type of col: str/double
if isnumeric(data{rt,c})
    % number
    sf = 0; % string-flag
elseif ischar(data{rt,c})
    % str
    sf = 1;
else
   error('Couldnt match item to column name') 
end
% get acceptable list
if strcmp(oper,'==') || strcmp(oper,'=')
    if sf % is string
        p=strcmp( data(:,c), items{2} );
    else % is number
        p= cell2mat(data(:,c))==str2double(items{2});
    end
elseif strcmp(oper,'>=')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))>=str2double(items{2});
    end
elseif strcmp(oper,'>')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))>str2double(items{2});
    end
elseif strcmp(oper,'<')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))<str2double(items{2});
    end
elseif strcmp(oper,'<=')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))<=str2double(items{2});
    end
elseif strcmp(oper,'!=') || strcmp(oper,'~=')
    if sf % is string
        p=~strcmp( data(:,c), items{2} );
    else % is number
        p=cell2mat(data(:,c))~=str2double(items{2});
    end
else
    error(strcat('Unrecognised operation:',oper));
end

outputData = data(p,:);
if usableFlag
    outputData=outputData(cell2mat(outputData(:,end))==1,:);
end