function [x,y,z,m,nb]=readposN(fileName,n)
if n == 0
    x=[];y=[];z=[];m=[];nb=0;
   return 
end
name = regexprep(fileName,'\.pos',''); % removes possible extention
fix='.pos';
name=strcat(name,fix);
fid = fopen(name, 'r');
if fid == -1
    error(['Couldn''t open file:' name]);
end

%lflo=fread(fid, inf, '4*float32', nskip,'b');
fileInfo = dir(name);
fileSize = fileInfo.bytes;
if fileSize/16 <= n
    n = fileSize/16;
    warning(strcat('Insufficient points in file:',name,'\n Truncating to',num2str(n),'_points'));
    [x,y,z,m,nb]=readpos(fileName);
    return
end
nskip = floor(fileSize/(16*n));
flo = zeros(n,4);

for k=1:n
    offset = (k-1)*16*(nskip)+floor(rand(1)*nskip)*16;
    %offset = (k-1)*16*(nskip+1);
    fseek( fid, offset, 'bof' );
    if feof(fid)
        warning('reached end of file');
        break
    end
    flo(k,:) = fread( fid, 4, 'float32', 0, 'b') ;
end


nb=numel(flo)/4;

[x,y,z,m] = deal(flo(:,1),flo(:,2),flo(:,3),flo(:,4));

clear flo
fclose(fid);
disp(strcat('OK, finished reading:',fileName,':',num2str(nb),' ions'));

end