function [boxSize,posVol] = maxBox(posName,samplePoints,sampleBoxes)
% get sample of pos
[x,y,z,~,nb]=readposN(posName,samplePoints);
pts = [x y z];
clear x y z nb

% get hull
[K,posVol]=convhull(pts);
disp(posVol);

% get normals
anchor = zeros(size(K,1),3);
normals = zeros(size(K,1),3);
for i=1:size(K,1)
    Pv = pts(K(i,:),:);
    d1 = Pv(1,:)-Pv(2,:);
    d2 = Pv(3,:)-Pv(2,:);
    anchor(i,:) = Pv(2,:);
    normals(i,:) = cross(d1,d2);
end

% initialisation for box finding
t=0;
cBest = [];
volBest = 0;
COM = mean(pts);
range = [min(pts); max(pts)]';
rangU = [min(pts(pts(:,3)<COM(3),:)); COM]';
rangL = [COM; max(pts)]';
RU = max(rangU(1:2,2)-rangU(1:2,1)); % radius upper
RL = max(rangL(1:2,2)-rangL(1:2,1)); % radius lower
q=[0 0 0; 1 0 0; 0 1 0; 0 0 1; 1 1 0; 1 0 1; 0 1 1; 1 1 1];
p=zeros(8,3);

while t<sampleBoxes
    ru = sqrt(rand(1))*RU; % random upper radius
    tu = rand(1)*pi/2; % random upper theta value
    rl = sqrt(rand(1))*RL; % random lower radius
    tl = rand(1)*pi/2; % random lower theta value
    c=  [COM(1)-ru.*cos(tu) COM(1)+rl.*cos(tl);...
         COM(2)-ru.*sin(tu) COM(2)+rl.*sin(tl); ...
         COM(3)-rand(1)*(rangU(3,2)-rangU(3,1)) COM(3)+rand(1)*(rangL(3,2)-rangL(3,1)) ]';
    %c = [delta.*rand(3,1) + rang(:,1) delta.*rand(3,1) + rang(:,1)]';
    vol = abs(prod(c(1,:)-c(2,:)));
    if vol>volBest
        if ~isempty(cBest)
            outside = 0; % outside hull?
            outsideBox = cubetest([min(c); max(c)],cBest);
            if outsideBox
                for i=1:size(q,1)
                    p(i,:)  = [ c(q(i,1)+1,1) c(q(i,2)+1,2)  c(q(i,3)+1,3) ];
                end
                outside=sum(fTest(p,anchor,normals));
            end
        else
            for i=1:size(q,1)
                p(i,:)  = [ c(q(i,1)+1,1) c(q(i,2)+1,2)  c(q(i,3)+1,3) ];
            end
            outside=sum(fTest(p,anchor,normals));
        end
        
        if ~outside
            cBest = [min(c); max(c)];
            volBest = vol;
        end
    end
    
    t=t+1;
end
boxSize = cBest;
end